#include <iostream>
#include <string>
#include <memory>
#include <sstream>
#include <cstdint>
#include <vector>
#include <map>

// Dagger runtime utilities
template<typename T>
using Ref = std::shared_ptr<T>;

template<typename T, typename... Args>
Ref<T> make_ref(Args&&... args) {
    return std::make_shared<T>(std::forward<Args>(args)...);
}

// Global error variable
int64_t _dagger__error_ = 0;

// List access helper (with bounds checking)
template<typename T>
T _dagger_list_get_(std::vector<T>& list, int64_t index) {
    if (index < 0 || index >= static_cast<int64_t>(list.size())) {
        _dagger__error_ = 1;
        return T{};
    }
    _dagger__error_ = 0;
    return list[index];
}

// Dict access helper (with missing key checking)
template<typename K, typename V>
V _dagger_dict_get_(std::map<K, V>& dict, const K& key) {
    auto it = dict.find(key);
    if (it == dict.end()) {
        _dagger__error_ = 1;
        return V{};
    }
    _dagger__error_ = 0;
    return it->second;
}


// String conversion utilities
std::string to_string(int64_t n) {
    return std::to_string(n);
}

std::string to_string(double n) {
    return std::to_string(n);
}

std::string to_string(const std::string& s) {
    return s;
}

template<typename T>
std::string to_string(const Ref<T>& obj) {
    if (obj) {
        return obj->_dagger_str_();
    }
    return "null";
}

// Imported inline C++
// Print function overloads
void _dagger_print_(const std::string& s) {
    std::cout << s << std::endl;
}

void _dagger_print_(int64_t n) {
    std::cout << n << std::endl;
}

// Input functions
std::string _dagger_input_() {
    std::string line;
    std::getline(std::cin, line);
    return line;
}

std::string _dagger_input_(const std::string& prompt) {
    std::cout << prompt;
    std::string line;
    std::getline(std::cin, line);
    return line;
}

// Forward declarations

// Class declarations

// Global function declarations

// Class implementations

// Global function implementations

// Entry point
int main() {
    _dagger_print_(std::string("hel	lo"));
    return 0;
}
